####################
# ## PARAMETERS ## #
####################

config = {
  # paths for connecting to cloud storage
  "vm_path": 'ebm-life-cycle/',
  "gs_path": 'gen-tfrc-uscentral1',

  # device type ('tpu' or 'gpu' or 'cpu')
  "device_type": 'tpu',
  # number of gpus if using gpu device
  #num_gpus: 1,

  # experiment info
  "exp_name": 'conv_sngan',
  "exp_dir": 'tfrc_out/imagenet2012',
  "num_training_steps": 1000000,
  "batch_size": 128,
  "image_dims": [64, 64, 3],

  # data type and augmentation parameters
  "data_type": 'imagenet2012',
  "random_crop": True,
  "data_epsilon": 2e-2,

  # ebm network
  "net_type": 'ebm_sngan',

  # learning rate for ebm
  "ebm_optim_type": 'adam',
  "ebm_lr_type": 'step',
  "ebm_lr_info": [[1e-4, 0], [1e-5, 50000], [1e-6, 70000], [1e-7, 90000], [1e-8, 110000]],
  "ebm_opt_decay": 0,

  # langevin sampling parameters
  "epsilon": 1e-2,
  "mcmc_step_info": [[100, 750, 100, 0]],
  "mcmc_init": "coop_persistent",
  "mcmc_temp": 1e-5,
  "tau": 1.5e-1,

  # prior network parameters
  "prior_weights": "gs://gen-tfrc-uscentral1/tfrc_out/imagenet2012/medconv_resnet_21-09-18-00-31-46/checkpoints/ebm_100000.ckpt",
  "prior_temp": 1e-5,

  # persistent image bank parameters
  "persistent_size": 10000,
  "burnin_size": 1000,
  "burnin_grad_updates": 0,

  # generator network parameters
  "gen_type": "gen_biggan_cond",
  "z_sz": 128,
  "truncation": 1,
  "update_generator": False,
  "gen_batch_norm": False,
  "gen_weights": 'gs://gen-tfrc-europewest4/biggan-128-deep_tf2/weights',

  # learning rate for gen
  # TODO: better LR schedule?
  "gen_optim_type": 'adam',
  "gen_lr_info": [[1e-4, 0]],
  "gen_opt_decay": 0.9999,

  # logging parameters
  "info_freq": 500,
  "log_freq": 5000,
  "save_networks": True,
  "save_to_cloud": True,

  # gradient clipping
  "max_grad_norm": 20,
  "clip_ebm_grad": False,
  "max_langevin_norm": 0.25,
  "clip_langevin_grad": False,

  # longrun parameters
  "log_longrun": False,
  "longrun_freq": 10000,
  "mcmc_steps_longrun": 100000
}
